<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/wallet.php');

// Include TheMonkeyPay processing
include('themonkeypay_wallet.php');
?>

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-wallet"></i> Wallet Recharge - TheMonkeyPay Gateway</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- Current Balance -->
                        <div class="col-md-4 mb-3">
                            <div class="alert alert-info">
                                <h6><i class="fas fa-rupee-sign"></i> Current Balance</h6>
                                <h3>₹<?php echo number_format($udata['wallet'], 2); ?></h3>
                            </div>
                        </div>
                        
                        <!-- Recharge Form -->
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <i class="fas fa-credit-card"></i> UPI Payment Gateway
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="">
                                        <div class="form-group">
                                            <label for="amount"><strong>Enter Amount</strong></label>
                                            <input type="number" 
                                                   class="form-control form-control-lg" 
                                                   name="amount" 
                                                   id="amount" 
                                                   placeholder="Enter amount (Min: ₹50, Max: ₹5000)" 
                                                   min="50" 
                                                   max="5000" 
                                                   required>
                                            <small class="text-muted">Minimum: ₹50 | Maximum: ₹5000</small>
                                        </div>
                                        
                                        <input type="hidden" name="email" value="<?php echo $udata['email']; ?>">
                                        
                                        <div class="form-group">
                                            <button type="submit" 
                                                    name="themonkeypay" 
                                                    class="btn btn-success btn-lg btn-block">
                                                <i class="fas fa-qrcode"></i> Pay via UPI
                                            </button>
                                        </div>
                                        
                                        <div class="alert alert-warning mb-0">
                                            <small>
                                                <i class="fas fa-info-circle"></i> 
                                                <strong>Note:</strong> After clicking "Pay via UPI", scan the QR code with any UPI app (GPay, PhonePe, Paytm, etc.)
                                            </small>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Transactions -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-header bg-dark text-white">
                    <h6 class="mb-0"><i class="fas fa-history"></i> Recent Transactions</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>Order ID</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>UTR/Ref</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $txn_query = mysqli_query($ahk_conn, "SELECT * FROM wallet WHERE phone='".$udata['phone']."' AND PAYMENTMODE='TheMonkeyPay' ORDER BY id DESC LIMIT 10");
                                
                                if(mysqli_num_rows($txn_query) > 0){
                                    while($txn = mysqli_fetch_assoc($txn_query)){
                                        $status_badge = '';
                                        if($txn['status'] == 'success'){
                                            $status_badge = '<span class="badge badge-success">Success</span>';
                                        } elseif($txn['status'] == 'pending'){
                                            $status_badge = '<span class="badge badge-warning">Pending</span>';
                                        } else {
                                            $status_badge = '<span class="badge badge-danger">Failed</span>';
                                        }
                                        ?>
                                        <tr>
                                            <td><small><?php echo $txn['txn_id']; ?></small></td>
                                            <td><strong>₹<?php echo number_format($txn['amount'], 2); ?></strong></td>
                                            <td><?php echo $status_badge; ?></td>
                                            <td><small><?php echo $txn['utr'] ?? 'N/A'; ?></small></td>
                                            <td><small><?php echo $txn['date']; ?></small></td>
                                        </tr>
                                        <?php
                                    }
                                } else {
                                    ?>
                                    <tr>
                                        <td colspan="5" class="text-center text-muted">No transactions found</td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border-radius: 10px;
    overflow: hidden;
}

.card-header {
    border-bottom: 2px solid rgba(255,255,255,0.2);
}

.btn-lg {
    padding: 12px 20px;
    font-size: 18px;
}

.table td, .table th {
    vertical-align: middle;
}

.badge {
    padding: 6px 12px;
    font-size: 12px;
}
</style>
