<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/wallet.php');

// TheMonkeyPay Gateway Integration
if(isset($_POST['themonkeypay']) && !empty($_POST['amount'])){
    $amount = mysqli_real_escape_string($ahk_conn, $_POST['amount']);
    $email = mysqli_real_escape_string($ahk_conn, $_POST['email']);
    $min_amount = 50; // Minimum amount
    $max_amount = 5000; // Maximum amount
    
    if(!empty($amount) && is_numeric($amount)){
        if($amount >= $min_amount && $amount <= $max_amount){
            date_default_timezone_set("Asia/Kolkata");
            $date = date("d-m-Y H:i:s");
            $ORDER_ID = $udata['phone'] . time() . rand(1000, 9999);
            
            // Insert pending transaction
            $ins = mysqli_query($ahk_conn, "INSERT INTO `wallet`(`phone`, `amount`, `txn_id`, `email`, `status`, `date`, `PAYMENTMODE`) 
                                           VALUES ('".$udata['phone']."', '$amount', '$ORDER_ID', '$email', 'pending', '$date', 'TheMonkeyPay')");
            
            if($ins){
                // Prepare API request
                $post_data = array(
                    'customer_mobile' => $udata['phone'],
                    'user_token'      => $flexsecure_upikey, // API Token from settings
                    'amount'          => $amount,
                    'order_id'        => $ORDER_ID,
                    'redirect_url'    => "https://" . $_SERVER['SERVER_NAME'] . "/user/themonkeypay_response.php",
                    'remark1'         => $udata['name'],
                    'remark2'         => "Wallet Recharge"
                );
                
                $api_url = "https://" . $flexsecure_upiUrl . "/api/create-order";
                
                // cURL request
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $api_url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                $response = curl_exec($ch);
                $curl_error = curl_error($ch);
                curl_close($ch);
                
                if($curl_error){
                    ?>
                    <script>
                    $(function(){
                        Swal.fire('Error!', 'Payment gateway connection failed. Please try again.', 'error');
                    });
                    </script>
                    <?php
                } elseif($response){
                    $resArray = json_decode($response, true);
                    
                    if($resArray && isset($resArray['status']) && $resArray['status'] == true){
                        $gateway_order_id = $resArray['result']['orderId'] ?? $ORDER_ID;
                        $payment_url = $resArray['result']['payment_url'] ?? '';
                        $qr_base64 = $resArray['result']['qr_data']['qr'] ?? '';
                        
                        // Update with gateway order ID
                        mysqli_query($ahk_conn, "UPDATE wallet SET txn_id='$gateway_order_id' WHERE txn_id='$ORDER_ID'");
                        
                        // Store in session
                        $_SESSION['gateway_order_id'] = $gateway_order_id;
                        $_SESSION['local_order_id'] = $ORDER_ID;
                        $_SESSION['payment_amount'] = $amount;
                        
                        if(!empty($qr_base64)){
                            $qr_image = "data:image/png;base64," . $qr_base64;
                            ?>
                            <script>
                            document.addEventListener("DOMContentLoaded", function() {
                                showQrPopup('<?php echo $qr_image; ?>', '<?php echo $payment_url; ?>', '<?php echo $gateway_order_id; ?>', '<?php echo $amount; ?>');
                            });
                            
                            function showQrPopup(qrImage, paymentUrl, orderId, amount) {
                                const modalHtml = `
                                    <div id="qrModal" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.85); z-index: 9999; display: flex; justify-content: center; align-items: center;">
                                        <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 25px; border-radius: 15px; text-align: center; max-width: 380px; width: 90%; box-shadow: 0 10px 40px rgba(0,0,0,0.3);">
                                            <h4 style="color: white; margin-bottom: 10px; font-weight: 600;">💳 Scan & Pay</h4>
                                            <div style="background: white; padding: 15px; border-radius: 10px; margin-bottom: 15px;">
                                                <h5 style="color: #28a745; font-weight: bold; margin-bottom: 10px;">Amount: ₹${amount}</h5>
                                                <img id="qrImageElement" src="${qrImage}" alt="QR Code" style="width: 220px; height: 220px; margin: 5px auto; display: block;">
                                                <p style="font-size: 12px; color: #666; margin-top: 10px;">Scan with any UPI app</p>
                                            </div>
                                            <p id="countdown" style="color: white; font-weight: 500; margin-bottom: 10px;"></p>
                                            <p id="statusMessage" style="color: #ffc107; font-size: 14px; margin-bottom: 15px;">⏳ Waiting for payment...</p>
                                            <p id="expiryMessage" style="display: none; color: #ff6b6b; font-weight: bold;"></p>
                                            <div style="display: flex; gap: 10px; justify-content: center;">
                                                <a href="${paymentUrl}" target="_blank" class="btn btn-light" style="padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: 500;">🔗 Open UPI</a>
                                                <button onclick="closeQrPopup()" style="padding: 10px 20px; background: rgba(255,255,255,0.2); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 500;">✕ Close</button>
                                            </div>
                                        </div>
                                    </div>
                                `;
                                document.body.insertAdjacentHTML("beforeend", modalHtml);
                                
                                // Start 5 minute countdown
                                startCountdown(300);
                                
                                // Check payment status every 3 seconds
                                const intervalId = setInterval(() => {
                                    checkPaymentStatus(orderId, intervalId);
                                }, 3000);
                                
                                // Stop checking after 5 minutes
                                setTimeout(() => {
                                    clearInterval(intervalId);
                                    expireQr();
                                }, 300000);
                            }
                            
                            function checkPaymentStatus(orderId, intervalId) {
                                const formData = new URLSearchParams();
                                formData.append("order_id", orderId);
                                
                                fetch("ajax_check_payment_status.php", {
                                    method: "POST",
                                    headers: { "Content-Type": "application/x-www-form-urlencoded" },
                                    body: formData
                                })
                                .then(r => r.json())
                                .then(res => {
                                    const statusMsg = document.getElementById("statusMessage");
                                    if(res.status === "TXN_SUCCESS"){
                                        clearInterval(intervalId);
                                        statusMsg.innerHTML = "✅ <span style='color: #28a745;'>Payment Successful!</span>";
                                        setTimeout(() => {
                                            window.location.href = "themonkeypay_response.php";
                                        }, 1500);
                                    } else if(res.status === "TXN_FAILURE"){
                                        clearInterval(intervalId);
                                        statusMsg.innerHTML = "❌ <span style='color: #dc3545;'>Payment Failed!</span>";
                                        setTimeout(() => closeQrPopup(), 3000);
                                    }
                                })
                                .catch(err => console.error("Status check error:", err));
                            }
                            
                            function startCountdown(duration) {
                                const countdownElement = document.getElementById("countdown");
                                let remaining = duration;
                                const timer = setInterval(() => {
                                    const minutes = Math.floor(remaining / 60);
                                    const seconds = remaining % 60;
                                    countdownElement.innerText = `⏱️ Time remaining: ${minutes}:${seconds < 10 ? "0" + seconds : seconds}`;
                                    remaining -= 1;
                                    if(remaining < 0) clearInterval(timer);
                                }, 1000);
                            }
                            
                            function expireQr() {
                                const qrImageElement = document.getElementById("qrImageElement");
                                const statusMessage = document.getElementById("statusMessage");
                                if(qrImageElement) qrImageElement.style.opacity = "0.3";
                                if(statusMessage) statusMessage.style.display = "none";
                                
                                const expiryMessage = document.getElementById("expiryMessage");
                                expiryMessage.style.display = "block";
                                let closeCounter = 10;
                                const closeTimer = setInterval(() => {
                                    expiryMessage.innerText = `⚠️ QR Code expired. Closing in ${closeCounter--} seconds...`;
                                    if(closeCounter <= 0){
                                        clearInterval(closeTimer);
                                        closeQrPopup();
                                    }
                                }, 1000);
                            }
                            
                            function closeQrPopup() {
                                const modal = document.getElementById("qrModal");
                                if(modal) modal.remove();
                            }
                            </script>
                            <?php
                        } else {
                            // No QR, redirect to payment URL
                            ?>
                            <script>
                            window.location.href = '<?php echo $payment_url; ?>';
                            </script>
                            <?php
                        }
                    } else {
                        $error_msg = $resArray['message'] ?? 'Payment gateway error. Please try again.';
                        ?>
                        <script>
                        $(function(){
                            Swal.fire('Error!', '<?php echo addslashes($error_msg); ?>', 'error');
                        });
                        </script>
                        <?php
                    }
                } else {
                    ?>
                    <script>
                    $(function(){
                        Swal.fire('Error!', 'Failed to connect to payment gateway.', 'error');
                    });
                    </script>
                    <?php
                }
            } else {
                ?>
                <script>
                $(function(){
                    Swal.fire('Error!', 'Failed to create transaction. Please try again.', 'error');
                });
                </script>
                <?php
            }
        } else {
            ?>
            <script>
            $(function(){
                Swal.fire('Error!', 'Amount should be between ₹<?php echo $min_amount; ?> and ₹<?php echo $max_amount; ?>', 'error');
            });
            </script>
            <?php
        }
    } else {
        ?>
        <script>
        $(function(){
            Swal.fire('Error!', 'Please enter a valid amount!', 'error');
        });
        </script>
        <?php
    }
}

// Success/Failed Messages
if(isset($_POST['success']) && $_POST['success'] == "true"){
    ?>
    <script>
    $(function(){
        Swal.fire('Success!', 'Payment Added Successfully!', 'success');
    });
    </script>
    <?php
}

if(isset($_POST['failed']) && $_POST['failed'] == "true"){
    ?>
    <script>
    $(function(){
        Swal.fire('Failed!', 'Payment Failed! If amount deducted, contact support.', 'error');
    });
    </script>
    <?php
}
?>
