<?php
include('../includes/session.php');
include('../includes/config.php');

if(isset($_SESSION['gateway_order_id']) && !empty($_SESSION['gateway_order_id'])){
    $gateway_order_id = $_SESSION['gateway_order_id'];
    $local_order_id = $_SESSION['local_order_id'] ?? $gateway_order_id;
    $customer_mobile = $udata['phone'];
    
    // TheMonkeyPay Status Check API
    $url = "https://" . $flexsecure_upiUrl . "/api/check_order_sts";
    $data = array("order_id" => $gateway_order_id);
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    $response = curl_exec($ch);
    $curl_error = curl_error($ch);
    curl_close($ch);
    
    if($curl_error){
        ?>
        <script>
        $(function(){
            Swal.fire('Error!', 'Failed to connect to payment gateway. Please try again.', 'error');
        });
        setTimeout(() => { window.location='wallet.php'; }, 2000);
        </script>
        <?php
        exit;
    }
    
    if($response === false){
        ?>
        <script>
        $(function(){
            Swal.fire('Error!', 'Failed to fetch order information.', 'error');
        });
        setTimeout(() => { window.location='wallet.php'; }, 2000);
        </script>
        <?php
        exit;
    }
    
    $resArray = json_decode($response, true);
    
    if($resArray === null || !isset($resArray['result'])){
        ?>
        <script>
        $(function(){
            Swal.fire('Error!', 'Invalid response from API.', 'error');
        });
        setTimeout(() => { window.location='wallet.php'; }, 2000);
        </script>
        <?php
        exit;
    }
    
    $txnStatus = $resArray["result"]["status"] ?? '';
    $txn_amount = $resArray["result"]["amount"] ?? 0;
    $utr_number = $resArray["result"]["bank_txn_id"] ?? $resArray["result"]["utr"] ?? '';
    $resultInfo = $resArray["result"]["resultInfo"] ?? '';
    
    // Check transaction in database
    $check_txn = mysqli_query($ahk_conn, "SELECT * FROM wallet WHERE txn_id='$gateway_order_id' AND status='pending'");
    
    if(mysqli_num_rows($check_txn) == 1){
        $txn_data = mysqli_fetch_assoc($check_txn);
        
        // Get user data
        $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='".$txn_data['phone']."'");
        $user_data = mysqli_fetch_assoc($user_query);
        
        if($user_data){
            $old_balance = $user_data['wallet'];
            $new_balance = $old_balance + $txn_amount;
            
            if($txnStatus === "TXN_SUCCESS"){
                // Update transaction status
                $update_txn = mysqli_query($ahk_conn, "UPDATE wallet SET 
                    status='success', 
                    utr='$utr_number',
                    amount='$txn_amount'
                    WHERE txn_id='$gateway_order_id'");
                
                if($update_txn){
                    // Update user wallet balance
                    mysqli_query($ahk_conn, "UPDATE users SET wallet='$new_balance' WHERE phone='".$user_data['phone']."'");
                    
                    // Send WhatsApp notification (if configured)
                    if(!empty($whatsappurl) && !empty($whapikey)){
                        $message = "Dear {$user_data['name']},\n\n" .
                                  "Amount: *₹{$txn_amount}* credited to your wallet.\n" .
                                  "Order ID: *{$gateway_order_id}*\n" .
                                  "UTR: *{$utr_number}*\n" .
                                  "Old Balance: *₹{$old_balance}*\n" .
                                  "New Balance: *₹{$new_balance}*\n\n" .
                                  "Thank you,\n*{$websiteName}*";
                        
                        $whatsapp_url = "{$whatsappurl}?key={$whapikey}&phone={$user_data['phone']}&msg=" . urlencode($message);
                        file_get_contents($whatsapp_url);
                    }
                    
                    // Clear session
                    unset($_SESSION['gateway_order_id']);
                    unset($_SESSION['local_order_id']);
                    unset($_SESSION['payment_amount']);
                    ?>
                    <script>
                    $(function(){
                        Swal.fire('Success!', 'Payment of ₹<?php echo $txn_amount; ?> added successfully!', 'success');
                    });
                    setTimeout(() => { window.location='wallet.php?success=true'; }, 2000);
                    </script>
                    <?php
                }
            } elseif($txnStatus === "TXN_FAILURE"){
                // Update as failed
                mysqli_query($ahk_conn, "UPDATE wallet SET 
                    status='failed',
                    utr='Failed: $resultInfo'
                    WHERE txn_id='$gateway_order_id'");
                
                unset($_SESSION['gateway_order_id']);
                unset($_SESSION['local_order_id']);
                ?>
                <script>
                $(function(){
                    Swal.fire('Failed!', 'Transaction failed! Please try again.', 'error');
                });
                setTimeout(() => { window.location='wallet.php?failed=true'; }, 2000);
                </script>
                <?php
            } else {
                // Pending status
                mysqli_query($ahk_conn, "UPDATE wallet SET status='pending' WHERE txn_id='$gateway_order_id'");
                ?>
                <script>
                $(function(){
                    Swal.fire('Pending!', 'Transaction is pending. Please wait or contact support.', 'warning');
                });
                setTimeout(() => { window.location='wallet.php'; }, 2000);
                </script>
                <?php
            }
        } else {
            ?>
            <script>
            $(function(){
                Swal.fire('Error!', 'User not found!', 'error');
            });
            setTimeout(() => { window.location='wallet.php'; }, 2000);
            </script>
            <?php
        }
    } else {
        // Check if already processed
        $success_check = mysqli_query($ahk_conn, "SELECT * FROM wallet WHERE txn_id='$gateway_order_id' AND status='success'");
        if(mysqli_num_rows($success_check) > 0){
            ?>
            <script>
            $(function(){
                Swal.fire('Already Processed!', 'This transaction was already completed.', 'info');
            });
            setTimeout(() => { window.location='wallet.php?success1=true'; }, 2000);
            </script>
            <?php
        } else {
            ?>
            <script>
            $(function(){
                Swal.fire('Error!', 'Transaction not found or duplicate payment.', 'error');
            });
            setTimeout(() => { window.location='wallet.php'; }, 2000);
            </script>
            <?php
        }
    }
} else {
    ?>
    <script>
    $(function(){
        Swal.fire('Error!', 'Session expired. Please check wallet history.', 'error');
    });
    setTimeout(() => { window.location='wallet.php'; }, 2000);
    </script>
    <?php
}
?>
