-- ====================================================================
-- TheMonkeyPay Gateway - Database Migration SQL
-- ====================================================================
-- Run this SQL in your phpMyAdmin or database console
-- Database: theporta_fast (या आपकी जो भी database है)
-- ====================================================================

-- Step 1: Add new columns to settings table
-- ====================================================================

-- Check if columns exist, if not add them
ALTER TABLE `settings` 
ADD COLUMN IF NOT EXISTS `upi_key` VARCHAR(500) DEFAULT NULL COMMENT 'TheMonkeyPay API Token (user_token)';

ALTER TABLE `settings` 
ADD COLUMN IF NOT EXISTS `pgurl` VARCHAR(100) DEFAULT 'themonkeypay.in' COMMENT 'Payment Gateway URL';

ALTER TABLE `settings` 
ADD COLUMN IF NOT EXISTS `pgtype` VARCHAR(20) DEFAULT 'inactive' COMMENT 'Gateway Status: active or inactive';

-- ====================================================================
-- Step 2: Update wallet table structure
-- ====================================================================

-- Add UTR column if not exists
ALTER TABLE `wallet` 
ADD COLUMN IF NOT EXISTS `utr` VARCHAR(255) DEFAULT NULL COMMENT 'Bank UTR/Reference Number';

-- Make sure PAYMENTMODE column is large enough
ALTER TABLE `wallet` 
MODIFY COLUMN `PAYMENTMODE` VARCHAR(50) DEFAULT NULL;

-- Add index for faster queries
ALTER TABLE `wallet` 
ADD INDEX IF NOT EXISTS `idx_txn_status` (`txn_id`, `status`);

ALTER TABLE `wallet` 
ADD INDEX IF NOT EXISTS `idx_phone_status` (`phone`, `status`);

-- ====================================================================
-- Step 3: Set default gateway URL (optional)
-- ====================================================================

UPDATE `settings` 
SET `pgurl` = 'themonkeypay.in' 
WHERE `id` = 1 AND (`pgurl` IS NULL OR `pgurl` = '');

-- ====================================================================
-- Step 4: Verify table structure
-- ====================================================================

-- Check settings table columns
DESCRIBE `settings`;

-- Check wallet table columns
DESCRIBE `wallet`;

-- ====================================================================
-- DONE! 
-- ====================================================================
-- Now upload PHP files and configure admin panel
-- ====================================================================
