<?php
include('../includes/session.php');
include('../includes/config.php');

// Check if user is admin
$userType = isset($udata['type']) ? $udata['type'] : '';

if (!checkAdmin($userType)) {
    echo "<script>window.location='index.php';</script>";
    exit;
}

include('../template/ahkweb/settings.php');

// Update TheMonkeyPay Settings
if(isset($_POST['update_themonkeypay'])){
    $upi_key = mysqli_real_escape_string($ahk_conn, $_POST['upi_key']);
    $pgurl = mysqli_real_escape_string($ahk_conn, $_POST['pgurl']);
    $pgtype = mysqli_real_escape_string($ahk_conn, $_POST['pgtype']);
    
    // Update settings
    $update = mysqli_query($ahk_conn, "UPDATE settings SET 
        upi_key='$upi_key',
        pgurl='$pgurl',
        pgtype='$pgtype'
        WHERE id=1");
    
    if($update){
        ?>
        <script>
        $(function(){
            Swal.fire('Success!', 'TheMonkeyPay settings updated successfully!', 'success');
        });
        setTimeout(() => { window.location=''; }, 1500);
        </script>
        <?php
    } else {
        ?>
        <script>
        $(function(){
            Swal.fire('Error!', 'Failed to update settings. <?php echo mysqli_error($ahk_conn); ?>', 'error');
        });
        </script>
        <?php
    }
}

// Get current settings
$settings = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM settings WHERE id=1"));
?>

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-cogs"></i> TheMonkeyPay Gateway Settings</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> 
                            <strong>Important:</strong> Enter your TheMonkeyPay API credentials. Get them from <a href="https://themonkeypay.in" target="_blank">TheMonkeyPay Dashboard</a>
                        </div>
                        
                        <div class="form-group">
                            <label for="pgurl"><i class="fas fa-link text-primary"></i> <strong>Gateway URL</strong></label>
                            <input type="text" 
                                   class="form-control" 
                                   name="pgurl" 
                                   id="pgurl" 
                                   value="<?php echo $settings['pgurl'] ?? 'themonkeypay.in'; ?>" 
                                   placeholder="themonkeypay.in" 
                                   required>
                            <small class="text-muted">Enter without https:// (Default: themonkeypay.in)</small>
                        </div>
                        
                        <div class="form-group">
                            <label for="upi_key"><i class="fas fa-key text-warning"></i> <strong>API Token (user_token)</strong></label>
                            <input type="text" 
                                   class="form-control" 
                                   name="upi_key" 
                                   id="upi_key" 
                                   value="<?php echo $settings['upi_key'] ?? ''; ?>" 
                                   placeholder="Enter TheMonkeyPay API Token" 
                                   required>
                            <small class="text-muted">Get this token from TheMonkeyPay admin panel</small>
                        </div>
                        
                        <div class="form-group">
                            <label for="pgtype"><i class="fas fa-toggle-on text-success"></i> <strong>Gateway Status</strong></label>
                            <select class="form-control" name="pgtype" id="pgtype" required>
                                <option value="active" <?php echo ($settings['pgtype'] ?? '') == 'active' ? 'selected' : ''; ?>>Active</option>
                                <option value="inactive" <?php echo ($settings['pgtype'] ?? '') == 'inactive' ? 'selected' : ''; ?>>Inactive</option>
                            </select>
                        </div>
                        
                        <hr>
                        
                        <div class="form-group mb-0">
                            <button type="submit" name="update_themonkeypay" class="btn btn-primary btn-lg btn-block">
                                <i class="fas fa-save"></i> Update Gateway Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Gateway Status Card -->
            <div class="card shadow mt-4">
                <div class="card-header bg-dark text-white">
                    <h6 class="mb-0"><i class="fas fa-server"></i> Current Configuration</h6>
                </div>
                <div class="card-body">
                    <table class="table table-bordered mb-0">
                        <tr>
                            <th width="200">Gateway Name</th>
                            <td><span class="badge badge-success">TheMonkeyPay</span></td>
                        </tr>
                        <tr>
                            <th>Gateway URL</th>
                            <td><code>https://<?php echo $settings['pgurl'] ?? 'themonkeypay.in'; ?></code></td>
                        </tr>
                        <tr>
                            <th>API Token</th>
                            <td>
                                <?php 
                                $token = $settings['upi_key'] ?? '';
                                if(!empty($token)){
                                    echo '<span class="text-success"><i class="fas fa-check-circle"></i> Configured</span> ';
                                    echo '<small class="text-muted">(' . substr($token, 0, 10) . '...)</small>';
                                } else {
                                    echo '<span class="text-danger"><i class="fas fa-times-circle"></i> Not Configured</span>';
                                }
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td>
                                <?php if(($settings['pgtype'] ?? '') == 'active' && !empty($settings['upi_key'])): ?>
                                    <span class="badge badge-success"><i class="fas fa-check"></i> Active & Ready</span>
                                <?php else: ?>
                                    <span class="badge badge-danger"><i class="fas fa-times"></i> Inactive</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>API Endpoints</th>
                            <td>
                                <small>
                                    <strong>Create Order:</strong> <code>/api/create-order</code><br>
                                    <strong>Check Status:</strong> <code>/api/check_order_sts</code>
                                </small>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            
            <!-- Help Card -->
            <div class="card shadow mt-4">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="fas fa-question-circle"></i> Setup Instructions</h6>
                </div>
                <div class="card-body">
                    <ol class="mb-0">
                        <li>Register/Login at <a href="https://themonkeypay.in" target="_blank">TheMonkeyPay.in</a></li>
                        <li>Go to API Settings in your dashboard</li>
                        <li>Copy your <strong>API Token (user_token)</strong></li>
                        <li>Paste it in the "API Token" field above</li>
                        <li>Keep Gateway URL as <code>themonkeypay.in</code></li>
                        <li>Set Status to <strong>Active</strong></li>
                        <li>Click <strong>Update Gateway Settings</strong></li>
                    </ol>
                    
                    <div class="alert alert-warning mt-3 mb-0">
                        <small>
                            <i class="fas fa-exclamation-triangle"></i> 
                            <strong>Important:</strong> Make sure your TheMonkeyPay account has sufficient balance for transactions.
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border-radius: 10px;
    overflow: hidden;
}

.card-header {
    border-bottom: 2px solid rgba(255,255,255,0.2);
}

code {
    background: #f4f4f4;
    padding: 2px 6px;
    border-radius: 3px;
}

.table th {
    background: #f8f9fa;
}
</style>
