# TheMonkeyPay Gateway Integration Guide
## Complete Setup Instructions

---

## 📁 FILE STRUCTURE

```
your_website_root/
│
├── user/
│   ├── themonkeypay_wallet.php          (Payment Processing Logic)
│   ├── wallet_recharge.php              (Main Recharge Page)
│   ├── themonkeypay_response.php        (Payment Callback Handler)
│   └── ajax_check_payment_status.php    (Auto Status Checker)
│
└── admin/
    └── admin_themonkeypay_settings.php  (Admin Configuration Panel)
```

---

## 🗄️ DATABASE CHANGES

### 1. Update `settings` table structure

Run this SQL in your database:

```sql
-- Add new columns to settings table
ALTER TABLE `settings` 
ADD COLUMN `upi_key` VARCHAR(500) DEFAULT NULL COMMENT 'TheMonkeyPay API Token',
ADD COLUMN `pgurl` VARCHAR(100) DEFAULT 'themonkeypay.in' COMMENT 'Payment Gateway URL',
ADD COLUMN `pgtype` VARCHAR(20) DEFAULT 'inactive' COMMENT 'Gateway Status: active/inactive';
```

### 2. Update `wallet` table structure

```sql
-- Add UTR column if not exists
ALTER TABLE `wallet` 
ADD COLUMN `utr` VARCHAR(255) DEFAULT NULL COMMENT 'Bank UTR/Reference Number';

-- Make sure these columns exist
ALTER TABLE `wallet` 
MODIFY COLUMN `PAYMENTMODE` VARCHAR(50) DEFAULT NULL;
```

---

## 📂 FILE UPLOAD INSTRUCTIONS

### **Step 1: Upload Files to `/user/` folder**

Upload these 4 files to your `user` or `dashboard` folder:

1. `themonkeypay_wallet.php`
2. `wallet_recharge.php`
3. `themonkeypay_response.php`
4. `ajax_check_payment_status.php`

**Important:** Make sure the path matches your existing wallet.php location!

### **Step 2: Upload Admin File**

Upload this file to your admin folder:

1. `admin_themonkeypay_settings.php`

---

## ⚙️ ADMIN PANEL CONFIGURATION

### **Step 1: Access Admin Settings**

1. Login to your admin panel
2. Navigate to: `your-domain.com/admin/admin_themonkeypay_settings.php`

### **Step 2: Configure Gateway**

Fill in these details:

- **Gateway URL:** `themonkeypay.in` (default, don't change)
- **API Token:** Get from TheMonkeyPay dashboard
- **Gateway Status:** Select `Active`

Click **"Update Gateway Settings"**

---

## 🔑 GET API TOKEN FROM THEMONKEYPAY

1. Visit: https://themonkeypay.in
2. Register/Login to your account
3. Go to **API Settings** section
4. Copy your **user_token** (API Token)
5. Paste it in admin settings

---

## 🎯 HOW TO USE

### **For Users:**

1. Go to: `your-domain.com/user/wallet_recharge.php`
2. Enter amount (Min: ₹50, Max: ₹5000)
3. Click **"Pay via UPI"**
4. QR code popup will appear
5. Scan with any UPI app (GPay, PhonePe, Paytm, etc.)
6. Payment auto-verifies in 3 seconds
7. Balance updates automatically

---

## 📝 FEATURES

✅ **QR Code Popup** - Beautiful gradient design  
✅ **Auto Payment Detection** - Checks every 3 seconds  
✅ **5 Minute Timer** - Auto-expires after timeout  
✅ **WhatsApp Notifications** - Success/failure alerts  
✅ **Transaction History** - Last 10 transactions  
✅ **UTR Tracking** - Bank reference numbers saved  
✅ **Duplicate Prevention** - No double payments  
✅ **Session Management** - Secure order tracking  

---

## 🔧 IMPORTANT VARIABLES IN config.php

Make sure your `config.php` has these variables:

```php
$flexsecure_upikey = $webdata['upi_key'];        // API Token
$flexsecure_upiUrl = $webdata['pgurl'];          // Gateway URL
$flexsecure_upikey2 = $webdata['pgtype'];        // Status (active/inactive)
$whatsappurl = $webdata['whurl'];                 // WhatsApp API URL
$whapikey = $webdata['whkey'];                    // WhatsApp API Key
$whsender = $webdata['whnumber'];                 // WhatsApp Sender Number
```

These are already in your config.php, so no changes needed!

---

## 🎨 MODIFY YOUR EXISTING wallet.php

### **Option 1: Replace wallet.php**

Simply rename `wallet_recharge.php` to `wallet.php` and replace your existing file.

### **Option 2: Add to Existing wallet.php**

Add this button to your existing wallet form:

```html
<!-- Add this form to your wallet.php -->
<div class="card">
    <div class="card-header bg-success text-white">
        <i class="fas fa-credit-card"></i> UPI Payment - TheMonkeyPay
    </div>
    <div class="card-body">
        <form method="POST" action="themonkeypay_wallet.php">
            <div class="form-group">
                <label>Enter Amount</label>
                <input type="number" class="form-control" name="amount" 
                       placeholder="Min: ₹50, Max: ₹5000" 
                       min="50" max="5000" required>
            </div>
            <input type="hidden" name="email" value="<?php echo $udata['email']; ?>">
            <button type="submit" name="themonkeypay" class="btn btn-success btn-block">
                <i class="fas fa-qrcode"></i> Pay via UPI
            </button>
        </form>
    </div>
</div>
```

---

## 🧪 TESTING

### **Test Payment Flow:**

1. Enter amount: ₹50
2. Click "Pay via UPI"
3. QR popup should appear
4. Try with test UPI ID (if provided by TheMonkeyPay)
5. Check status auto-updates
6. Verify wallet balance increases

---

## ❌ TROUBLESHOOTING

### **Problem: QR Code not showing**

**Solution:** Check if `upi_key` is configured in admin settings

### **Problem: Payment not updating**

**Solution:** 
- Check `ajax_check_payment_status.php` path
- Verify API token is correct
- Check database `wallet` table for pending status

### **Problem: "Failed to connect to payment gateway"**

**Solution:**
- Verify `pgurl` is set to `themonkeypay.in`
- Check internet connection
- Ensure cURL is enabled on server

### **Problem: Session expired error**

**Solution:**
- Make sure session is started in config.php
- Check `session.php` includes proper session handling

---

## 📞 SUPPORT

**TheMonkeyPay Support:**
- Website: https://themonkeypay.in
- Email: support@themonkeypay.in

**Developer Support:**
- For integration issues, check error logs
- Test API endpoints manually
- Verify database columns exist

---

## ⚡ QUICK START CHECKLIST

- [ ] Upload all 5 files to correct folders
- [ ] Run SQL queries to add new columns
- [ ] Configure admin settings with API token
- [ ] Set gateway status to "Active"
- [ ] Test with small amount (₹50)
- [ ] Verify balance updates
- [ ] Check transaction history
- [ ] Test WhatsApp notifications (if configured)

---

## 🎉 DONE!

Your TheMonkeyPay integration is complete! Users can now recharge wallet using UPI with QR code popup.

**Last Updated:** January 2026  
**Version:** 1.0  
**Developer:** Devloper_JK
